package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aBandaContaminanteDao;
import com.ejie.aa17a.model.Aa17aBandaContaminante;
import com.ejie.x38.dto.Pagination;

/**
 * Aa17aBandaContaminanteDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aBandaContaminanteDaoImpl implements Aa17aBandaContaminanteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aBandaContaminante> rwMap = new RowMapper<Aa17aBandaContaminante>() {
		public Aa17aBandaContaminante mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa17aBandaContaminante(
					resultSet.getLong("IDCONTAMINANTE"), resultSet.getLong("IDBANDA"), resultSet.getBigDecimal("VALORMINIMO"), resultSet.getBigDecimal("VALORMAXIMO")
			);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17abandacontaminante
	 *            Pagination
	 * @return Aa17aBandaContaminante
	 */
	public Aa17aBandaContaminante add(Aa17aBandaContaminante aa17abandacontaminante) {
		String query = "INSERT INTO AA17A_BANDA_CONTAMINANTE (ID_CONTAMINANTE, ID_BANDA, VALOR_MINIMO, VALOR_MAXIMO) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, aa17abandacontaminante.getIdContaminante(), aa17abandacontaminante.getIdBanda(), aa17abandacontaminante.getValorMinimo(), aa17abandacontaminante.getValorMaximo());
		return aa17abandacontaminante;
	}

	/**
	 * Updates a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17abandacontaminante
	 *            Pagination
	 * @return Aa17aBandaContaminante
	 */
	public Aa17aBandaContaminante update(Aa17aBandaContaminante aa17abandacontaminante) {
		String query = "UPDATE AA17A_BANDA_CONTAMINANTE SET  WHERE ID_CONTAMINANTE=? AND ID_BANDA=? AND VALOR_MINIMO=? AND VALOR_MAXIMO=?";
		this.jdbcTemplate.update(query, aa17abandacontaminante.getIdContaminante(), aa17abandacontaminante.getIdBanda(), aa17abandacontaminante.getValorMinimo(), aa17abandacontaminante.getValorMaximo());
		return aa17abandacontaminante;
	}

	/**
	 * Finds a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17abandacontaminante
	 *            Pagination
	 * @return Aa17aBandaContaminante
	 */
	@Transactional(readOnly = true)
	public Aa17aBandaContaminante find(Aa17aBandaContaminante aa17abandacontaminante) {
		String query = "SELECT t1.ID_CONTAMINANTE IDCONTAMINANTE, t1.ID_BANDA IDBANDA, t1.VALOR_MINIMO VALORMINIMO, t1.VALOR_MAXIMO VALORMAXIMO FROM AA17A_BANDA_CONTAMINANTE t1  WHERE t1.ID_CONTAMINANTE = ?   AND t1.ID_BANDA = ?   AND t1.VALOR_MINIMO = ?   AND t1.VALOR_MAXIMO = ?  ";

		List<Aa17aBandaContaminante> aa17abandacontaminanteList = this.jdbcTemplate.query(query, this.rwMap, aa17abandacontaminante.getIdContaminante(), aa17abandacontaminante.getIdBanda(), aa17abandacontaminante.getValorMinimo(), aa17abandacontaminante.getValorMaximo());
		return (Aa17aBandaContaminante) DataAccessUtils.uniqueResult(aa17abandacontaminanteList);
	}

	/**
	 * Removes a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17abandacontaminante
	 *            Pagination
	 * @return
	 */
	public void remove(Aa17aBandaContaminante aa17abandacontaminante) {
		String query = "DELETE FROM AA17A_BANDA_CONTAMINANTE WHERE ID_CONTAMINANTE=? AND ID_BANDA=? AND VALOR_MINIMO=? AND VALOR_MAXIMO=?";
		this.jdbcTemplate.update(query, aa17abandacontaminante.getIdContaminante(), aa17abandacontaminante.getIdBanda(), aa17abandacontaminante.getValorMinimo(), aa17abandacontaminante.getValorMaximo());
	}

	/**
	 * Finds a List of rows in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17abandacontaminante
	 *            Aa17aBandaContaminante
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aBandaContaminante> findAll(Aa17aBandaContaminante aa17abandacontaminante, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_CONTAMINANTE IDCONTAMINANTE,t1.ID_BANDA IDBANDA,t1.VALOR_MINIMO VALORMINIMO,t1.VALOR_MAXIMO VALORMAXIMO ");
		query.append("FROM AA17A_BANDA_CONTAMINANTE t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17abandacontaminante);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aa17aBandaContaminante>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17abandacontaminante
	 *            Aa17aBandaContaminante
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa17aBandaContaminante aa17abandacontaminante) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA17A_BANDA_CONTAMINANTE t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17abandacontaminante);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Aa17aBandaContaminante table using like.
	 * 
	 * @param aa17abandacontaminante
	 *            Aa17aBandaContaminante
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aBandaContaminante> findAllLike(Aa17aBandaContaminante aa17abandacontaminante, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_CONTAMINANTE IDCONTAMINANTE,t1.ID_BANDA IDBANDA,t1.VALOR_MINIMO VALORMINIMO,t1.VALOR_MAXIMO VALORMAXIMO ");
		query.append("FROM AA17A_BANDA_CONTAMINANTE t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa17abandacontaminante, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aa17aBandaContaminante>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aa17aBandaContaminante table using like.
	 * 
	 * @param aa17abandacontaminante
	 *            Aa17aBandaContaminante
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa17aBandaContaminante aa17abandacontaminante, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA17A_BANDA_CONTAMINANTE t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa17abandacontaminante, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aBandaContaminante entity
	 * 
	 * @param aa17abandacontaminante
	 *            Aa17aBandaContaminante Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aBandaContaminante aa17abandacontaminante) {

		StringBuffer where = new StringBuffer(Aa17aBandaContaminanteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17abandacontaminante != null && aa17abandacontaminante.getIdContaminante() != null) {
			where.append(" AND t1.ID_CONTAMINANTE = ?");
			params.add(aa17abandacontaminante.getIdContaminante());
		}
		if (aa17abandacontaminante != null && aa17abandacontaminante.getIdBanda() != null) {
			where.append(" AND t1.ID_BANDA = ?");
			params.add(aa17abandacontaminante.getIdBanda());
		}
		if (aa17abandacontaminante != null && aa17abandacontaminante.getValorMinimo() != null) {
			where.append(" AND t1.VALOR_MINIMO = ?");
			params.add(aa17abandacontaminante.getValorMinimo());
		}
		if (aa17abandacontaminante != null && aa17abandacontaminante.getValorMaximo() != null) {
			where.append(" AND t1.VALOR_MAXIMO = ?");
			params.add(aa17abandacontaminante.getValorMaximo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aBandaContaminante entity
	 * 
	 * @param aa17abandacontaminante
	 *            Aa17aBandaContaminante Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Aa17aBandaContaminante aa17abandacontaminante, Boolean startsWith) {

		StringBuffer where = new StringBuffer(Aa17aBandaContaminanteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17abandacontaminante != null && aa17abandacontaminante.getIdContaminante() != null) {
			where.append(" AND t1.ID_CONTAMINANTE = ?");
		}
		if (aa17abandacontaminante != null && aa17abandacontaminante.getIdBanda() != null) {
			where.append(" AND t1.ID_BANDA = ?");
		}
		if (aa17abandacontaminante != null && aa17abandacontaminante.getValorMinimo() != null) {
			where.append(" AND t1.VALOR_MINIMO = ?");
		}
		if (aa17abandacontaminante != null && aa17abandacontaminante.getValorMaximo() != null) {
			where.append(" AND t1.VALOR_MAXIMO = ?");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
